/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class XSeriesEnrollment
implements Serializable {
    private static final String TRACE_MASKT = "XSASXSET";
    private static final String TRACE_MASKF = "XSASXSEF";
    private static final String TRACE_MASKD = "XSASXSED";
    private static final String XSERIES_ENROLLMENT = "xseries-enrollment";
    private static final String AGENT_VERSION = "service-agent-version";
    private static final String LEVEL_NAME = "service-level-name";
    private static final String LEVEL_VERSION = "service-level-version";
    private static final String LEVEL_DATE = "service-level_DATE";
    private static final String REQUESTS_ENABLED = "service-requests-enabled";
    private static final String REQUESTS_SUSPENDED = "service-requests-suspended";
    private static final String REQUEST_DIAGNOSTICS_ENABLED = "service-request-diagnostics-enabled";
    private static final String CONTACT_NAME = "contact-name";
    private static final String CONTACT_PHONE = "contact-phone";
    private static final String CONTACT_EXTENSION = "contact-extension";
    private static final String CONTACT_EMAIL = "contact-email";
    private static final String LOCALE = "locale";
    private static final String LAST_UPDATE_TIMESTAMP = "last-update_TIMESTAMP";
    public String agentVersion;
    public String levelName;
    public String levelVersion;
    public Date levelDate;
    public String requestsEnabled;
    public String requestsSuspended;
    public String requestDiagnosticsEnabled;
    public String contactName;
    public String contactPhone;
    public String contactExtension;
    public String contactEmail;
    public Locale locale;
    public Date lastUpdateTimestamp;

    public XSeriesEnrollment(String agentVersion, String requestsEnabled, String requestsSuspended, String requestDiagnosticsEnabled, String contactName, String contactPhone, String contactEmail, Date lastUpdateTimestamp) {
        this(agentVersion, null, null, null, requestsEnabled, requestsSuspended, requestDiagnosticsEnabled, contactName, contactPhone, null, contactEmail, null, lastUpdateTimestamp);
        Trace.trace(TRACE_MASKT, "<> XSeriesEnrollment.XSeriesEnrollment(agentVersion=" + agentVersion + ", " + "requestsEnabled=" + requestsEnabled + ", " + "requestsSuspended=" + requestsSuspended + ", " + "requestDiagnosticsEnabled=" + requestDiagnosticsEnabled + ", " + "contactName=" + contactName + ", " + "contactPhone=" + contactPhone + ", " + "contactEmail=" + contactEmail + ", " + "locale=" + this.locale + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public XSeriesEnrollment(String agentVersion, String levelName, String levelVersion, Date levelDate, String requestsEnabled, String requestsSuspended, String requestDiagnosticsEnabled, String contactName, String contactPhone, String contactExtension, String contactEmail, Locale locale, Date lastUpdateTimestamp) {
        this.agentVersion = agentVersion;
        this.levelName = levelName;
        this.levelVersion = levelVersion;
        this.levelDate = levelDate;
        this.requestsEnabled = requestsEnabled;
        this.requestsSuspended = requestsSuspended;
        this.requestDiagnosticsEnabled = requestDiagnosticsEnabled;
        this.contactName = contactName;
        this.contactPhone = contactPhone;
        this.contactExtension = contactExtension;
        this.contactEmail = contactEmail;
        this.locale = locale;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        Trace.trace(TRACE_MASKT, "<> XSeriesEnrollment.XSeriesEnrollment(agentVersion=" + agentVersion + ", " + "levelName=" + levelName + ", " + "levelVersion=" + levelVersion + ", " + "levelDate=" + levelDate + ", " + "requestsEnabled=" + requestsEnabled + ", " + "requestsSuspended=" + requestsSuspended + ", " + "requestDiagnosticsEnabled=" + requestDiagnosticsEnabled + ", " + "contactName=" + contactName + ", " + "contactPhone=" + contactPhone + ", " + "contactExtension=" + contactExtension + ", " + "contactEmail=" + contactEmail + ", " + "locale=" + locale + ", " + "lastUpdateTimestamp=" + lastUpdateTimestamp + ")");
    }

    public String toXml() {
        SimpleDateFormat dateFormat;
        Trace.trace(TRACE_MASKT, "-> XSeriesEnrollment.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(XSERIES_ENROLLMENT);
        buffer.append(" ");
        buffer.append("service-agent-version=\"" + SasUtil.convert4Xml(this.agentVersion) + "\"");
        if (this.levelName != null && this.levelName.length() > 0) {
            buffer.append(" ");
            buffer.append("service-level-name=\"" + SasUtil.convert4Xml(this.levelName) + "\"");
        }
        if (this.levelVersion != null && this.levelVersion.length() > 0) {
            buffer.append(" ");
            buffer.append("service-level-version=\"" + SasUtil.convert4Xml(this.levelVersion) + "\"");
        }
        if (this.levelDate != null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            buffer.append(" ");
            buffer.append("service-level_DATE=\"" + SasUtil.convert4Xml(dateFormat.format(this.levelDate)) + "\"");
        }
        buffer.append(" ");
        buffer.append("service-requests-enabled=\"" + SasUtil.convert4Xml(this.requestsEnabled) + "\"");
        buffer.append(" ");
        buffer.append("service-requests-suspended=\"" + SasUtil.convert4Xml(this.requestsSuspended) + "\"");
        buffer.append(" ");
        buffer.append("service-request-diagnostics-enabled=\"" + SasUtil.convert4Xml(this.requestDiagnosticsEnabled) + "\"");
        buffer.append(" ");
        buffer.append("contact-name=\"" + SasUtil.convert4Xml(this.contactName) + "\"");
        buffer.append(" ");
        buffer.append("contact-phone=\"" + SasUtil.convert4Xml(this.contactPhone) + "\"");
        if (this.contactExtension != null && this.contactExtension.length() > 0) {
            buffer.append(" ");
            buffer.append("contact-extension=\"" + SasUtil.convert4Xml(this.contactExtension) + "\"");
        }
        buffer.append(" ");
        buffer.append("contact-email=\"" + SasUtil.convert4Xml(this.contactEmail) + "\"");
        if (this.locale != null) {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(this.locale.toString()) + "\"");
        } else {
            buffer.append(" ");
            buffer.append("locale=\"" + SasUtil.convert4Xml(Locale.getDefault().toString()) + "\"");
        }
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        buffer.append(" ");
        buffer.append("last-update_TIMESTAMP=\"" + SasUtil.convert4Xml(dateFormat.format(this.lastUpdateTimestamp)) + "\"");
        buffer.append("/>");
        Trace.trace(TRACE_MASKT, "<- XSeriesEnrollment.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> XSeriesEnrollment.clone()");
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<- XSeriesEnrollment.clone()");
        return o;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> XSeriesEnrollment.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof XSeriesEnrollment) {
            XSeriesEnrollment xSeriesEnrollment = (XSeriesEnrollment)object;
            if (this.agentVersion.equals(xSeriesEnrollment.agentVersion) && this.levelName.equals(xSeriesEnrollment.levelName) && this.levelVersion.equals(xSeriesEnrollment.levelVersion) && this.levelDate.equals(xSeriesEnrollment.levelDate) && this.requestsEnabled.equals(xSeriesEnrollment.requestsEnabled) && this.requestsSuspended.equals(xSeriesEnrollment.requestsSuspended) && this.requestDiagnosticsEnabled.equals(xSeriesEnrollment.requestDiagnosticsEnabled) && this.contactName.equals(xSeriesEnrollment.contactName) && this.contactPhone.equals(xSeriesEnrollment.contactPhone) && this.contactExtension.equals(xSeriesEnrollment.contactExtension) && this.contactEmail.equals(xSeriesEnrollment.contactEmail) && this.locale.equals(xSeriesEnrollment.locale) && this.lastUpdateTimestamp.equals(xSeriesEnrollment.lastUpdateTimestamp)) {
                return true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- XSeriesEnrollment.equals()");
        return result;
    }
}

